% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multi_EVPI.R
\name{multi_EVPI}
\alias{multi_EVPI}
\alias{summary.EVPI_outputs}
\alias{summary_multi_EVPI}
\alias{plot.EVPI_outputs}
\alias{plot_multi_EVPI}
\title{Expected value of perfect information (EVPI) for multiple variables. This
is a wrapper for the empirical_EVPI function. See the documentation of the 
\code{\link{empirical_EVPI}} function for more details.}
\usage{
multi_EVPI(mc, first_out_var, write_table = FALSE, outfolder = NA)

\method{summary}{EVPI_outputs}(object, ...)

\method{plot}{EVPI_outputs}(x, out_var, fileformat = NA,
  outfolder = NA, scale_results = TRUE, legend_table = NULL,
  output_legend_table = NULL, ...)
}
\arguments{
\item{mc}{output table from a Monte Carlo simulation,
e.g. as realized with the decisionSupport package}

\item{first_out_var}{name of the column in the mc table that contains the first output
variable. Information Values are computed for variables in all earlier columns.}

\item{write_table}{boolean parameter indicating whether an output table should be written.}

\item{outfolder}{folder where the outputs should be saved (this is optional).}

\item{object}{EVPI_res object (produced with multi_EVPI) as input to the
summary function plot.}

\item{...}{Arguments to be passed to methods, such as graphical parameters (see par).}

\item{x}{object of class EVPI_outputs as produced with the multi_EVPI function}

\item{out_var}{name of the output variable to be plotted
 param fileformat The file format to be used for the outputs. Currently only
NA (for R plot output) and "png" (for a PNG file) are implemented. Note that
when this is !NA, the outfolder parameter must point to a valid folder.}

\item{fileformat}{The file format to be used for the outputs. Currently only
NA (for R plot output) and "png" (for a PNG file) are implemented. Note that
when this is !NA, the outfolder parameter must point to a valid folder.}

\item{scale_results}{boolean variable indicating if resulting high numbers
should be scaled to avoid numbers in the plot that cannot be read easily. If
this is TRUE, numbers are divided by an appropriate divisor and a suffix is
added to the number in the plot (e.g. "in millions").}

\item{legend_table}{a data.frame with two columns variable and label. The
variable column should contain the name of the independent variables as
listed in the Monte Carlo table. The label column should contain the label
to be used for this variable in the EVPI plot.}

\item{output_legend_table}{a data.frame with two columns variable and label.
The variable column should contain the name of the dependent variables as
listed in the Monte Carlo table. The label column should contain the label
to be used for this variable in the EVPI plot. Note that labels for both
dependent and independent variables can be provided in the same table. Then
both parameters legend_table and output_legend_table can point to the same
table.}
}
\value{
invisible list of as many elements as there are output variables 
  in the Monte Carlo table:
  each element refers to one of the output variables and contains a data.frame with five
  columns:
  (1) variable - the input variable names
  (2) expected_gain - expected gain when project is
  implemented, without knowing the value of the test
  variable, equals NA in case there is no variation in the tested variable
  (3) EVPI_do - the Expected Value of Perfect Information on the respective input variable,
  if the analysis suggests that the expected value of the decision is likely positive
  (e.g. the project should be done)
  (4) EVPI_dont - the Expected Value of Perfect Information on the respective input variable,
  if the analysis suggests that the expected value of the decision is likely negative
  (e.g. the project should not be done)
  (5) the decision whether to implement with the project based on imperfect information
}
\description{
Expected value of perfect information (EVPI) for multiple variables. This
is a wrapper for the empirical_EVPI function. See the documentation of the 
\code{\link{empirical_EVPI}} function for more details.
}
\examples{


### In the following example, the sign of the calculation
### is entirely determined by the variable indep1, so
### this should be expected to have a high EVPI. Variable
### indep2 doesn't affect the sign of the output, so it
### should not have information value.

montecarlo <- data.frame(indep1 = rnorm(1000), indep2 = rnorm(1000, 3))
montecarlo[, 'output1'] <- montecarlo[, 'indep1'] * montecarlo[, 'indep2']
montecarlo[, 'output2'] <- (montecarlo[, 'indep1'] * (montecarlo[, 'indep2']) + 10)

results_all <- multi_EVPI(montecarlo,"output1")
summary(results_all)
plot(results_all, "output1")
plot(results_all, "output2")


### In the following example, the sign of the calculation is entirely
### determined by the variable indep1, so this should be expected to have
### a high EVPI. Variable indep2 doesn't affect the sign of the output,
### so it should not have information value.

montecarlo <- data.frame(indep1 = rnorm(1000), indep2 = rnorm(1000, mean = 3))
montecarlo[, 'output1'] <- montecarlo[, 'indep1'] * montecarlo[, 'indep2']
montecarlo[, 'output2'] <- (montecarlo[, 'indep1'] * (montecarlo[, 'indep2']) + 10)

results_all <- multi_EVPI(montecarlo,"output1")
summary(results_all)
plot(results_all, "output1")
plot(results_all, "output2")

}
\author{
Eike Luedeling, Katja Schiffers
}
\keyword{"Value}
\keyword{Information"}
\keyword{of}
