% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mut.to.sigs.input.R
\name{mut.to.sigs.input}
\alias{mut.to.sigs.input}
\title{Converts mutation list to correct input format}
\usage{
mut.to.sigs.input(mut.ref, sample.id = "Sample", chr = "chr", pos = "pos",
  ref = "ref", alt = "alt")
}
\arguments{
\item{mut.ref}{Location of the mutation file that is to be converted or name
of data frame in environment}

\item{sample.id}{Column name in the mutation file corresponding to the Sample
ID}

\item{chr}{Column name in the mutation file corresponding to the chromosome}

\item{pos}{Column name in the mutation file corresponding to the mutation
position}

\item{ref}{Column name in the mutation file corresponding to the reference
base}

\item{alt}{Column name in the mutation file corresponding to the alternate
base}
}
\value{
A data frame that contains sample IDs for the rows and trinucleotide
  contexts for the columns. Each entry is the count of how many times a
  mutation with that trinucleotide context is seen in the sample.
}
\description{
Given a mutation list, outputs a data frame with counts of how frequently a
mutation is found within each trinucleotide context per sample ID.  Output
can be used as input into getTriContextFraction.
}
\examples{
\dontrun{
sigs.input = mut.to.sigs.input(mut.ref = sample.mut.ref, 
                               sample.id = "Sample", 
                               chr = "chr", 
                               pos = "pos", 
                               ref = "ref", 
                               alt = "alt")
}
}

