% Generated by roxygen2 (4.0.1): do not edit by hand
\name{untangle}
\alias{untangle}
\alias{untangle.default}
\alias{untangle.dendlist}
\alias{untangle.dendrogram}
\title{untangle dendrograms}
\usage{
untangle(dend1, ...)

\method{untangle}{dendrogram}(dend1, dend2 ,
   method = c("random", "step1side", "step2side", "DendSer"),
   ...)

\method{untangle}{dendlist}(dend1, method, which = c(1L,2L), ...)
}
\arguments{
\item{dend1}{a dednrogram or a dendlist object}

\item{dend2}{A second dednrogram (to untangle against)}

\item{which}{an integer vector of length 2, indicating
which of the trees in the dendlist object should be plotted}

\item{method}{a character indicating the type of untangle
heuristic to use.}

\item{...}{passed to the releavnt untangle function}
}
\value{
A \link{dendlist}, with two trees after
they have been untangled.
}
\description{
One untangle function to rule them all.

This function untangles dendrogram lists (dendlist),
Using various heuristics.
}
\details{
This function wraps all of the untagnle functions,
in order to make it easier to find our about (and use) them.
}
\examples{
\dontrun{
set.seed(23235)
ss <- sample(1:150, 10 )
dend1 <- iris[ss,-5] \%>\% dist \%>\% hclust("com") \%>\% as.dendrogram
dend2 <- iris[ss,-5] \%>\% dist \%>\% hclust("sin") \%>\% as.dendrogram
dend12 <- dendlist(dend1, dend2)

dend12 \%>\% tanglegram

untangle(dend1, dend2, method="random", R = 5) \%>\% tanglegram

# it works, and we get something different:
set.seed(1234)
dend12 \%>\% untangle(method="random", R = 5) \%>\% tanglegram

set.seed(1234)
# fixes it completely:
dend12 \%>\% untangle(method="random", R = 5) \%>\% untangle(method="step1") \%>\% tanglegram
# not good enough
dend12 \%>\% untangle(method="step1") \%>\% tanglegram
# not good enough
dend12 \%>\% untangle(method="step2") \%>\% tanglegram
# How we might wish to use it:
set.seed(12777)
dend12 \%>\%
   untangle(method="random", R = 1) \%>\%
   untangle(method="step2") \%>\%
   tanglegram

}
}
\author{
Tal Galili
}
\seealso{
\link{tanglegram}, \link{untangle_random_search},
\link{untangle_step_rotate_1side}, \link{untangle_step_rotate_2side},
\link{entanglement}
}

