% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor.dendlist.R
\name{cor.dendlist}
\alias{cor.dendlist}
\title{Correlation matrix between a list of trees.}
\usage{
cor.dendlist(dend, method = c("cophenetic", "baker", "common_nodes",
  "FM_index"), ...)
}
\arguments{
\item{dend}{a \link{dendlist} of trees}

\item{method}{a character string indicating which correlation coefficient 
is to be computed. One of "cophenetic" (default),  "baker", 
"common_nodes", or "FM_index".
It can be abbreviated.}

\item{...}{passed to cor functions.}
}
\value{
A correlation matrix between the different trees
}
\description{
A correlation matrix between a list of trees.

Assumes the labels in the two trees fully match. If they do not
please first use \link{intersect_trees} to have them matched.
}
\examples{

\dontrun{

set.seed(23235)
ss <- sample(1:150, 10 )
dend1 <- iris[ss,-5] \%>\% dist \%>\% hclust("com") \%>\% as.dendrogram
dend2 <- iris[ss,-5] \%>\% dist \%>\% hclust("single") \%>\% as.dendrogram
dend3 <- iris[ss,-5] \%>\% dist \%>\% hclust("ave") \%>\% as.dendrogram
dend4 <- iris[ss,-5] \%>\% dist \%>\% hclust("centroid") \%>\% as.dendrogram
#    cutree(dend1)   
cors <- cor.dendlist(dendlist(d1 = dend1, d2 = dend2, d3 = dend3, d4 = dend4))

cors

# a nice plot for them:
library(corrplot)
corrplot(cor.dendlist(dend1234), "pie", "lower")

}
}
\seealso{
\link{cophenetic}, \link{cor_cophenetic}, \link{cor_bakers_gamma},
\link{cor_common_nodes}, \link{cor_FM_index}
}
