% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infrastructure.R
\name{use_data}
\alias{use_data}
\title{Use data in a package.}
\usage{
use_data(..., pkg = ".", internal = FALSE, overwrite = FALSE,
  compress = "bzip2")
}
\arguments{
\item{...}{Unquoted names of existing objects to save.}

\item{pkg}{Package where to store data. Defaults to package in working
directory.}

\item{internal}{If \code{FALSE}, saves each object in individual
\code{.rda} files in the \code{data/} directory. These are available
whenever the package is loaded. If \code{TRUE}, stores all objects in
a single \code{R/sysdata.rda} file. These objects are only available
within the package.}

\item{overwrite}{By default, \code{use_data} will not overwrite existing
files. If you really want to do so, set this to \code{TRUE}.}

\item{compress}{Choose the type of compression used by \code{\link{save}}.
Should be one of "gzip", "bzip2" or "xz".}
}
\description{
This function makes it easy to save package data in the correct format.
}
\examples{
\dontrun{
x <- 1:10
y <- 1:100

use_data(x, y) # For external use
use_data(x, y, internal = TRUE) # For internal use
}
}
\seealso{
Other infrastructure: \code{\link{infrastructure}},
  \code{\link{use_build_ignore}},
  \code{\link{use_data_raw}}, \code{\link{use_news_md}},
  \code{\link{use_package}}, \code{\link{use_readme_rmd}}
}

