% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r-hub.R
\name{check_rhub}
\alias{check_rhub}
\title{Run CRAN checks for package on R-hub}
\usage{
check_rhub(pkg = ".", platforms = NULL, email = NULL,
  interactive = TRUE, build_args = NULL, ...)
}
\arguments{
\item{pkg}{package description, can be path or package name.  See
\code{\link[=as.package]{as.package()}} for more information}

\item{platforms}{R-hub platforms to run the check on. If \code{NULL}
uses default list of CRAN checkers (one for each major platform, and
one with extra checks if you have compiled code). You can also specify
your own, see \code{\link[rhub:platforms]{rhub::platforms()}} for a complete list.}

\item{email}{email address to notify, defaults to the maintainer
address in the package.}

\item{interactive}{whether to show the status of the build
interactively. R-hub will send an email to the package maintainer's
email address, regardless of whether the check is interactive or not.}

\item{build_args}{Arguments passed to \code{R CMD build}}

\item{...}{extra arguments, passed to \code{\link[rhub:check_for_cran]{rhub::check_for_cran()}}.}
}
\value{
a \code{rhub_check} object.
}
\description{
It runs \code{\link[=build]{build()}} on the package, with the arguments specified
in \code{args}, and then submits it to the R-hub builder at
\url{https://builder.r-hub.io}. The \code{interactive} option controls
whether the function waits for the check output. Regardless, after the
check is complete, R-hub sends an email with the results to the package
maintainer.
}
\section{About email validation on r-hub}{

To build and check R packages on R-hub, you need to validate your
email address. This is because R-hub sends out emails about build
results. See more at \code{\link[rhub:validate_email]{rhub::validate_email()}}.
}

\seealso{
Other build functions: \code{\link{check_win}}
}
\concept{build functions}
