% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotate2d.R
\name{rotate2d}
\alias{rotate2d}
\title{Polar Coordinates Rotation}
\usage{
rotate2d(T, degree = 0)
}
\arguments{
\item{T}{a numeric matrix (normally z-score converted) with 2 columns. The rows are genes or phosphorylation
sites and the columns are treatments vs control statistics.}

\item{degree}{the direction to be tested for enrichment. Specified as degree from to the original direction.}
}
\value{
A rotated matrix with respect to the direction of interest.
}
\description{
Rotate to the direction of interest in polar coordinates by degree (e.g. pi/4).
}
\examples{
# load the phosphoproteomics dataset
data(HEK)

# convert statistics into z-scores
HEK.zscores <- apply(HEK, 2, function(x){qnorm(rank(x)/(nrow(HEK)+1))})

# Rotate the matrix by 1/2 pi (i.e. down-regulation, dow-regulation).
HEK.rotated <- rotate2d(HEK.zscores, degree = pi/2)

}
