% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bouts_helpers.R
\name{boutfreqs}
\alias{boutfreqs}
\title{Histogram of log-transformed frequencies}
\usage{
boutfreqs(x, bw, method = c("standard", "seq.diff"), plot = TRUE, ...)
}
\arguments{
\item{x}{numeric vector on which bouts will be identified based on
\dQuote{method}. For \code{labelBouts} it can also be a matrix with
different variables for which bouts should be identified.}

\item{bw}{numeric scalar: bin width for the histogram.}

\item{method}{character: method used for calculating the frequencies:
\dQuote{standard} simply uses x, while \dQuote{seq.diff} uses the
sequential differences method.}

\item{plot}{logical, whether to plot results or not.}

\item{...}{For \code{boutfreqs}, arguments passed to hist (must exclude
\code{breaks} and \code{include.lowest})}
}
\value{
\code{boutfreqs} returns an object of class \code{Bouts}, with slot
\code{lnfreq} consisting of a data frame with components \var{lnfreq}
containing the log frequencies and \var{x}, containing the
corresponding mid points of the histogram.  Empty bins are excluded. A
plot (histogram of \emph{input data}) is produced as a side effect if
argument plot is \code{TRUE}.  See the Details section.
}
\description{
Histogram of log-transformed frequencies
}
\author{
Sebastian P. Luque \email{spluque@gmail.com}
}
