% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/diversity.R
\name{dim_balance}
\alias{dim_balance}
\title{Main measures of balance}
\usage{
dim_balance(data, entity_col = FALSE)
}
\arguments{
\item{data}{A numeric matrix with entities \eqn{i} in the rows and categories \eqn{j} in the columns. Cells show the respective value (value of abundance) of entity \eqn{i} in the category \eqn{j}. It can also be a transpose of the previous matrix, that is, a matrix with categories in the rows and entities in the columns. Yet in that case, the parameter "entity_col" has to be set to TRUE. The matrix must include names for the rows and the columns. The parameter "data", also accepts a dataframe with three columns in the following order: entity, category and value.}

\item{entity_col}{A flag to indicate that entities are in the columns. The analysis assumes that the entities are in the rows of the matrix. If the entities are in the columns and the categories in the rows, then the parameter "entity_col" has to be set to TRUE. The default value is FALSE.}
}
\value{
A data frame that includes the measures of balance: Shannon entropy, Herfindahl-Hirschman Index (HHI), Gini-Simpson (and its derivated measures I, index of diversity and R, reciprocal Simpson) and Shannon evenness.
}
\description{
A procedure to compute several measures associated with the balance or evenness of categories.
}
\examples{
dim_balance(pantheon)
}

