% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/dPvalAggregate.r
\name{dPvalAggregate}
\alias{dPvalAggregate}
\title{Function to aggregate p values}
\usage{
dPvalAggregate(pmatrix, method = c("orderStatistic", "fishers",
"Ztransform"),
order = ncol(pmatrix), weight = rep(1, ncol(pmatrix)))
}
\arguments{
\item{pmatrix}{a data frame or matrix of p-values}

\item{method}{the method used. It can be either "orderStatistic" for
the method based on the order statistics of p-values, or "fishers" for
Fisher's method, or "Ztransform" for Z-transform test (and the weighted
Z-test)}

\item{order}{an integeter specifying the order used for the aggregation
according to the order statistics of p-values}

\item{weight}{a vector specifying the weights used for the aggregation
according to Z-transform method}
}
\value{
\itemize{
\item{\code{ap}: a vector with the length nrow(pmatrix), containing
aggregated p-values}
}
}
\description{
\code{dPvalAggregate} is supposed to aggregate a input matrix p-values
into a vector of aggregated p-values. The aggregate operation is
applied to each row of input matrix, each resulting in an aggregated
p-value. The method implemented can be based on the order statistics of
p-values or according to Fisher's method or Z-transform method.
}
\note{
For each row of input matrix with the \eqn{c} columns, there are
\eqn{c} p-values that are uniformly independently distributed over
[0,1] under the null hypothesis (uniform distribution). According to
the order statisitcs, they follow the Beta distribution with the
paramters \eqn{a=order} and \eqn{b=c-order+1}. According to the
Fisher's method, after transformation by \eqn{-2*\sum^clog(pvalue)},
they follow Chi-Squared distribution. According to the Z-transform
method, first converts the one-tailed P-values into standard normal
deviates Z, then combines Z via \eqn{\frac{\sum^c(w*Z)}{\sum^c(w^2)}},
where \eqn{w} is the weight (usually square root of the sample size if
the weighted Z-test; 1 if Z-transform test), and finally the combined Z
follows the standard normal distribution to test the
cumulative/aggregated evidence on the common null hypothesis.
}
\examples{
# 1) generate an iid uniformly-distributed random matrix of 1000x3
pmatrix <- cbind(runif(1000), runif(1000), runif(1000))

# 2) aggregate according to the order statistics
ap <- dPvalAggregate(pmatrix, method="orderStatistic")

# 3) aggregate according to the Fisher's method
ap <- dPvalAggregate(pmatrix, method="fishers")

# 4) aggregate according to the Z-transform method
ap <- dPvalAggregate(pmatrix, method="Ztransform")
}
\seealso{
\code{\link{dPvalAggregate}}
}

