% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/main.R
\name{FedorovWynn}
\alias{FedorovWynn}
\title{Fedorov Wynn}
\usage{
FedorovWynn(mod, sNames = NULL, names = NULL, tolAbs = Inf,
  tolRel = 1e-04, maxIter = 10000)
}
\arguments{
\item{mod}{some model.}

\item{sNames}{a vector of names or indices, the subset of parameters to optimize for.}

\item{names}{a vector of names or indices, the set of parameters use.}

\item{tolAbs}{the absolute tolerance regarding the sensitivities.}

\item{tolRel}{the relative tolerance regarding the sensitivities with respect to the theoretical limit.}

\item{maxIter}{the maximum number of iterations.}
}
\value{
\code{FedorovWynn} returns an object of \code{class} \code{"desigh"}.
An object of class \code{"desigh"} is a list containing the following components:
\itemize{
\item mod: argument
\item x: a row matrix of design points, here identical to \code{mod$x}.
\item w: a numeric vector of weights, for each design point respectively.
\item sens: a numeric vector of sensitivities, for each design point respectively.
\item args: a list of arguments.
\item adds: a list of additional (runtime) information.
}
}
\description{
\code{FedorovWynn} finds a D- or Ds-optimal design using a Fedorov-Wynn-type algorithm.
}
\details{
Both \code{sNames} and \code{names} default to the set of parameters for which the Fisher information is available.

The algorithm starts from a uniform weight design.
In each iteration weight is redistributed to the point which has the highest sensitivity.
Sequence: \code{1/i}.
The algorithm stops when all sensitivities are below a certain absolute and relative tolerance level, or the maximum number of iterations is reached.
}
\examples{
## see examples for param
}
\references{
Fedorov, V. V. (1971) The Design of Experiments in the Multiresponse Case.
\emph{Theory of Probability and its Applications}, 16(2):323-332.

Wynn, Henry P. (1970) The Sequential Generation of D-Optimum Experimental Designs.
\emph{The Annals of Mathematical Statistics}, 41(5):1655-1664.
}
\seealso{
\code{\link{param}}, \code{\link{getM}}, \code{\link{reduce}}, \code{\link{plot.desigh}}, \code{\link{Defficiency}}, \code{\link{update.desigh}}
}

