% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/main.R
\name{plot.desigh}
\alias{plot.desigh}
\title{Plot Design}
\usage{
\method{plot}{desigh}(x, ..., margins = NULL, wDes = NULL, plus = T,
  circles = F, border = c(0.1, 0.1, 0, 0.1), sensArgs = list(),
  wArgs = list())
}
\arguments{
\item{x}{some design.}

\item{...}{other arguments passed to plot.}

\item{margins}{a vector of indices, the dimensions to project on.
Defaults to \code{1}.}

\item{wDes}{a design to take weights from.
Defaults to \code{x}.
See \code{reduce}.}

\item{plus}{add plus symbols to the sensitivity.}

\item{circles}{draw weights as circles instead of as bars.}

\item{border}{(if drawing circles) \code{c(bottom, left, top, right)}, the relative margins to add.}

\item{sensArgs}{a list of arguments to use for drawing the sensitivities.}

\item{wArgs}{a list of arguments to use for drawing the weights.}
}
\description{
\code{plot.desigh} creates a one dimensional plot of sensitivities and weights.
If the design space has additional dimensions, the design is projected on a specified margin.
}
\details{
If \code{plus=T}, \code{wDes} is specified and its sensitivities contain missing values, then the latter are linearly interpolated from the sensitivities in \code{x}.

If \code{circles=T}, the diameter of each circle is proportional to the corresponding weight.
}
\examples{
## see examples for param
}
\references{
uses add.alpha from \url{http://www.magesblog.com/2013/04/how-to-change-alpha-value-of-colours-in.html}
}
\seealso{
\code{\link{FedorovWynn}}, \code{\link{reduce}}
}

