% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_run.R
\name{extract_dpcr}
\alias{extract_dpcr}
\title{Extract Assays or Experiments}
\usage{
extract_dpcr(input, id_exper = NULL, id_assay = NULL)
}
\arguments{
\item{input}{object of the class \code{\linkS4class{adpcr}} or
\code{\linkS4class{dpcr}}.}

\item{id_exper}{vector of indices or names of experiments. Must be \code{NULL} if
\code{id_assay} is specified.}

\item{id_assay}{vector of indices or names of assays. Must be \code{NULL} if
\code{id_exper} is specified.}
}
\value{
The object of the input's class (\code{\linkS4class{adpcr}} or
\code{\linkS4class{dpcr}}).
}
\description{
Extract all runs belonging to specific assay or experiment(s) from a 
code{\linkS4class{dpcr}} object while preserving all other
attributes.
}
\note{
The standard \code{\link[base]{Extract}} operator \code{x[i]} treats
dpcr objects as \code{matrix} and extracts values without preserving other
attributies of the object.
}
\examples{

#extract using only experiment's ID
extract_dpcr(six_panels, id_exper = 1)

#extract using assay name
extract_dpcr(six_panels, id_assay = "MYC")

#extract using multiple names
extract_dpcr(six_panels, id_exper = c("Experiment1", "Experiment2"))

}
\seealso{
Extract run(s): \code{\link{extract_run}}.
}
\author{
Michal Burdukiewicz.
}
\keyword{extract}
\keyword{manip}
\keyword{panel}
