\name{est.black.box4}
\alias{est.black.box4}
\alias{bft}
\title{Estimate a TSmodel}
\description{Estimate a TSmodel with Brute Force Technique.}
\usage{
    est.black.box4(data, estimation="est.VARX.ls", 
                lag.weight=1.0,  variable.weights=1, 
                reduction="reduction.Mittnik", 
                criterion="taic", 
                trend=F, subtract.means=F,  re.add.means=T, 
                standardize=F, verbose=T, max.lag=12, sample.start=10, warn=T)
    bft(data, ... )
}
\arguments{
    \item{data}{A TSdata object.}
    \item{estimation}{a character string indicating the estimation method to use.}
    \item{lag.weight}{weighting to apply to lagged observations. }
    \item{variable.weights}{
       weighting to apply to series if estimation method is est.wt.variables.}
    \item{reduction}{character string indicating reduction procedure to use.}
    \item{criterion}{criterion to be used for model 
       selection. see \code{information.tests.calculations}.}
    \item{trend}{if T include a trend in the model.}
    \item{subtract.means}{
       if T the mean is subtracted from the data before estimation.}
    \item{re.add.means}{
       if subtract.means is T then if re.add.means is T the estimated model is
       converted back to a model for data without the mean subtracted.}
    \item{standardize}{
     if T the data is transformed so that all variables have the same variance.}
    \item{verbose}{
       if T then additional information from the estimation and reduction 
       procedures is printed.}
    \item{max.lag}{VAR estimation is done for each lag up to max.lag.}
    \item{sample.start}{
       the starting point to use for calculating information criteria in the 
       final selection.}
    \item{warn}{logical indicating if warning messages should be suppressed.}
    \item{...}{arguments passed to est.black.box4.}
}
\value{A TSestModel.}
\details{
For each lag up to max.lag a VAR model is estimated and then a
reduction procedure applied to select the best reduced model. Finally
the best of the best reduced models is selected. The default estimation
procedure is least squares estimation of the VAR models. This procedure
is described as the brute force technique (bft) in Gilbert (1995).
}
\references{
    Gilbert, P.D. (1995) "Combining VAR Estimation and State Space 
    Model Reduction for Simple Good Predictions" J. of Forecasting: 
    Special Issue on VAR Modelling. 14:229-250.
}
\seealso{
\code{\link{est.black.box1}},
\code{\link{est.black.box2}}
\code{\link{est.black.box3}}
\code{\link[dse1]{information.tests.calculations}}
}
\examples{
if(is.R()) data("eg1.DSE.data.diff", package="dse1")
z <-  bft(eg1.DSE.data.diff)
}
%\keyword{DSE}
\keyword{ts}


