% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecop-plot-option-method.R
\name{ecop.plot_option}
\alias{ecop.plot_option}
\title{Plot option chain charts using conf from option sample data}
\usage{
ecop.plot_option(object, otype, simulate = TRUE)
}
\arguments{
\item{object}{an ecop object with conf}

\item{otype}{option type}

\item{simulate}{logic, if \code{TRUE}, simulate according to lambda transformation and lambda distribution.}
}
\value{
The \code{ecop.opt} object
}
\description{
This utility produces standardized plots of 3.
The first plot is the option state price and fits.
The second plot is the log-slope of option state prices and fits.
The thrid plot is the implied volatility and fits.
}
\examples{
\dontrun{
    op <- ecop.from_symbol_conf("spx2_1d")
    par(mfcol=c(3,2))
    ecop.plot_option(op, otype="c")
    ecop.plot_option(op, otype="p")
}
}
\author{
Stephen H-T. Lihn
}
\keyword{plot}

