% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecld-cdf-method.R
\name{ecld.cdf}
\alias{ecld.cdf}
\alias{ecld.ccdf}
\alias{ecld.cdf_integrate}
\alias{ecld.cdf_gamma}
\title{CDF and CCDF of ecld}
\usage{
ecld.cdf(object, x)

ecld.ccdf(object, x)

ecld.cdf_integrate(object, x)

ecld.cdf_gamma(object, x)
}
\arguments{
\item{object}{an object of ecld class}

\item{x}{a numeric vector of \code{x}}
}
\value{
The CDF or CCDF vector
}
\description{
The analytic solutions for CDF and CCDF of ecld, if available.
\code{ecld.cdf_gamma} is a sub-module with the CDF expressed as
incomplete gamma function.
SGED is supported only in \code{ecld.cdf} and \code{ecld.ccdf}.
}
\examples{
ld <- ecld(sigma=0.01*ecd.mp1)
x <- seq(-0.1, 0.1, by=0.01)
ecld.cdf(ld,x)
}
\author{
Stephen H. Lihn
}
\keyword{cdf}
