% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operator.mutator.uniform.R
\name{mutUniform}
\alias{mutUniform}
\title{Uniform mutator.}
\usage{
mutUniform(ind, lower, upper)
}
\arguments{
\item{ind}{[\code{numeric}]\cr
Numeric vector / individual to mutate.}

\item{lower}{[\code{numeric}]\cr
Vector of minimal values for each parameter of the decision space.}

\item{upper}{[\code{numeric}]\cr
Vector of maximal values for each parameter of the decision space.}
}
\value{
[\code{numeric}]
}
\description{
This mutation operator works on real-valued genotypes only. It selects a position
in the solution vector at random and replaced it with a uniformally chosen value
within the box constraints of the corresponding parameter.
This mutator may proof beneficial in early stages of the optimization process,
since it distributes points widely within the box constraints and thus may
hinder premature convergence. However, in later stages - when fine tuning is
necessary, this feature is disadvantegous.
}
\seealso{
Other mutators: \code{\link{mutBitflip}},
  \code{\link{mutGauss}}, \code{\link{mutInsertion}},
  \code{\link{mutPolynomial}}, \code{\link{mutScramble}},
  \code{\link{mutSwap}}
}
