% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/filter_time_period.R
\name{filter_time_period}
\alias{filter_time_period}
\title{Filter: Time Period}
\usage{
filter_time_period(eventlog, start_point, end_point,
  filter_method = "contained", reverse = FALSE)
}
\arguments{
\item{eventlog}{The event log to be used. An object of class
\code{eventlog}.}

\item{start_point}{Start timestamp of the time period. This should be a date object.}

\item{end_point}{End timestamp of the time period. This should be a data object.}

\item{filter_method}{Can be \code{contained, start, complete, intersecting} or \code{trim}.
\code{contained} keeps all the events related to cases contained in the time period.
\code{start} keeps all the events related to cases started in the time period.
\code{complete} keeps all the events related to cases complete in the time period.
\code{intersecting} keeps all the events related to cases in which at least one event started and/or ended in the time period.
\code{trim} keeps all the events which started and ended in the time frame.}

\item{reverse}{A logical parameter depicting whether the selection should be reversed.}
}
\description{
Function to filter eventlog using a time period.
}

