% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getFilingHeader.R
\name{getFilingHeader}
\alias{getFilingHeader}
\title{Scrape EDGAR filing header information}
\usage{
getFilingHeader(cik.no, form.type, filing.year, useragent)
}
\arguments{
\item{cik.no}{vector of CIK(s) in integer format. Suppress leading 
zeroes from CIKs. cik.no = 'ALL' conisders all the CIKs.}

\item{form.type}{character vector containing form type to be downloaded. 
form.type = 'ALL' if need to download all forms.}

\item{filing.year}{vector of four digit numeric year}

\item{useragent}{Should be in the form of "Your Name Contact@domain.com"}
}
\value{
Function returns dataframe containing CIK number, company name, 
date of filing, accession number, confirmed period of report, fiscal year end,
Standard Industrial Classification (SIC) code, Internal Revenue Code (IRS) 
code, state of incorporation, business address, and mailing address. If a 
filing contains multiple filers then output will contain header information on 
all the filers in multiple rows.
}
\description{
\code{getFilingHeader} Extract EDGAR filing header information
}
\details{
getFilingHeader function takes CIK(s), form type(s), and year(s) as input parameters.  
The function first imports available downloaded filings in local woking directory 
'Edgar filings_full text' created by \link[edgar]{getFilings} function; 
otherwise, it automatically downloads the filings which are not already been 
downloaded. It then parses all the important header information from filings.
The function returns a dataframe with filing and header information. According 
to SEC EDGAR's guidelines a user also needs to declare user agent.
}
\examples{
\dontrun{

header.df <- getFilingHeader(cik.no = c('1000180', '38079'), 
                         form.type = '10-K', filing.year = 2006, useragent) 
              
header.df <- getFilingHeader(cik.no = '38079', c('10-K', '10-Q'), 
                         filing.year = c(2005, 2006), useragent)
}
}
