% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eem_utils.R
\name{eem_set_wavelengths}
\alias{eem_set_wavelengths}
\title{Set Excitation and/or Emission wavelengths}
\usage{
eem_set_wavelengths(eem, ex, em)
}
\arguments{
\item{eem}{An object of class \code{eemlist}.}

\item{ex}{A numeric vector of excitation wavelengths.}

\item{em}{A numeric vector of emission wavelengths.}
}
\value{
An object of class \code{eemlist}.
}
\description{
This function allows to manully specify either excitation or emission vector
of wavelengths in EEMs. This function is mostly used with spectrophotometers
such as Shimadzu that do not include excitation wavelengths in fluorescence
files.
}
\examples{
folder <- system.file("extdata/shimadzu", package = "eemR")

eem <- eem_read(folder)
eem <- eem_set_wavelengths(eem, ex = seq(230, 450, by = 5))

plot(eem)

}

