% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/modsims.R
\name{gelmansim}
\alias{gelmansim}
\title{Generate prediction intervals for model functions}
\usage{
gelmansim(mod, newdata, n.sims, na.omit = TRUE)
}
\arguments{
\item{mod}{Name of a model object such as \code{\link{lm}}, \code{\link{glm}}, or \code{merMod}}

\item{newdata}{Sets of new data to generate predictions for}

\item{n.sims}{Number of simulations per case}

\item{na.omit}{Logical indicating whether to remove NAs from \code{newdata}}
}
\value{
A dataframe with newdata and prediction intervals
}
\description{
Generate prediction intervals from R models following Gelman and Hill
}
\details{
Currently gelmansim does not work for \code{\link{lm}} objects because of the way \code{\link{sim}} in the
\code{arm} package handles variable names for these objects. It is recommended users use \code{\link{glm}} in these cases.
}
\examples{
#Examples of "sim"
set.seed (1)
J <- 15
n <- J*(J+1)/2
group <- rep (1:J, 1:J)
mu.a <- 5
sigma.a <- 2
a <- rnorm (J, mu.a, sigma.a)
b <- -3
x <- rnorm (n, 2, 1)
sigma.y <- 6
y <- rnorm (n, a[group] + b*x, sigma.y)
u <- runif (J, 0, 3)
y123.dat <- cbind (y, x, group)
# Linear regression
x1 <- y123.dat[,2]
y1 <- y123.dat[,1]
M1 <- glm (y1 ~ x1)

cases <- data.frame(x1 = seq(-2, 2, by=0.1))
sim.results <- gelmansim(M1, newdata=cases, n.sims=200, na.omit=TRUE)
\dontrun{

dat <- as.data.frame(y123.dat)
M2 <- glm (y1 ~ x1 + group, data=dat)

cases <- expand.grid(x1 = seq(-2, 2, by=0.1),
                     group=seq(1, 14, by=2))

sim.results <- gelmansim(M2, newdata=cases, n.sims=200, na.omit=TRUE)

}
}
\references{
Modified from Gelman and Hill 2006. Data Analysis Using Regression and Multilevel/Hierarchical Models. Cambridge University Press.
}

