% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate.R
\name{validate}
\alias{validate}
\title{Validate a search}
\usage{
validate(conn, index, type = NULL, ...)
}
\arguments{
\item{conn}{an Elasticsearch connection object, see \code{\link[=connect]{connect()}}}

\item{index}{Index name. Required.}

\item{type}{Document type. Optional.}

\item{...}{Additional args passed on to \code{\link[=Search]{Search()}}}
}
\description{
Validate a search
}
\examples{
\dontrun{
x <- connect()

if (!index_exists(x, "twitter")) index_create(x, "twitter")
docs_create(x, 'twitter', type='tweet', id=1, body = list(
   "user" = "foobar", 
   "post_date" = "2014-01-03",
   "message" = "trying out Elasticsearch"
 )
)
validate(x, "twitter", q='user:foobar')
validate(x, "twitter", "tweet", q='user:foobar')

body <- '{
"query" : {
  "bool" : {
    "must" : {
      "query_string" : {
        "query" : "*:*"
      }
    },
    "filter" : {
      "term" : { "user" : "kimchy" }
    }
  }
}
}'
validate(x, "twitter", body = body)
}
}
\seealso{
\code{\link[=Search]{Search()}}
}
