% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STRN.R
\name{STRN}
\alias{STRN}
\title{Estimate the parameters that best describe the sexualisation thermal reaction norm within the TSP}
\usage{
STRN(Initial_STRN = NULL,
  EmbryoGrowthTRN = stop("Embryo Growth Thermal Reaction Norm must be provided"),
  tsd = stop("A result from the function tsd() must be provided"),
  Sexed = NULL, Males = NULL, Females = NULL,
  Temperatures = "TSP.MassWeighted.STRNWeighted.temperature.mean",
  SE = FALSE, ...)
}
\arguments{
\item{Initial_STRN}{Values for initial model of Sexualisation Thermal Reaction Norm}

\item{EmbryoGrowthTRN}{The Embryo Growth Thermal Reaction Norm obtained with searchR()}

\item{tsd}{The model used to predict sex ratio, obtained from tsd()}

\item{Sexed}{The number of sexed embryos with names identifying timeseries}

\item{Males}{The number of males embryos with names identifying timeseries}

\item{Females}{The number of females embryos with names identifying timeseries}

\item{Temperatures}{The temperature from out of info.nests to be used}

\item{SE}{Should standard error of parameters be estimated ? TRUE or FALSE}

\item{...}{Parameters used for control of optimx()}
}
\value{
The list with object return by optim()
}
\description{
Estimate the parameters that best describe the sexualisation thermal reaction norm within the TSP.\cr
The Temperatures parameter is a character string which can be:\cr
\itemize{
  \item \code{TimeWeighted.temperature.mean}
  \item \code{TSP.TimeWeighted.temperature.mean}
  \item \code{TSP.MassWeighted.temperature.mean}
  \item \code{TSP.STRNWeighted.temperature.mean}
  \item \code{TSP.MassWeighted.STRNWeighted.temperature.mean}
  \item \code{MiddleThird.TimeWeighted.temperature.mean}
  }
If information for sex is not known for some timeseries, set NA for Sexed.\cr
Sexed, Males and Females must be vectors with names. The names must be the same as 
the names of timeseries of temperatures in EmbryoGrowthTRN.\cr
Only two of these 3 parameters are required: Males, Females and Sexed\cr
}
\details{
STRN estimates the parameters that best describe the sexualisation thermal reaction norm within the TSP
}
\examples{
\dontrun{
library(embryogrowth)
MedIncubation_Cc <- subset(DatabaseTSD, Species=="Caretta caretta" & 
RMU=="Mediterranean" & Sexed!=0)
Med_Cc <- with(MedIncubation_Cc, tsd(males=Males, females=Females, 
 temperatures=Incubation.temperature, par=c(P=29.5, S=-0.01)))
plot(Med_Cc, xlim=c(25, 35))
# Initial_STRN <- rep(1, 7)
# names(Initial_STRN) <- as.character(seq(from=20, to=35, length=7))
Initial_STRN <- structure(c(1, 143.248982215757, -25.7029976477549, -0.00489843027318209,
-8.94560833594928, 135.781961273868, 71.2176230826628), 
.Names = c("20", "22.5", "25", "27.5", "30", "32.5", "35"))
males <- c(7, 0, 0, 0, 0, 5, 6, 3, 5, 3, 2, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0)
names(males) <- rev(rev(names(resultNest_4p$data))[-(1:2)])
sexed <- rep(10, length(males))
names(sexed) <- rev(rev(names(resultNest_4p$data))[-(1:2)])
fitSTRN <- STRN(Initial_STRN, EmbryoGrowthTRN=resultNest_4p, tsd=Med_Cc, 
Sexed=sexed, Males=males, 
Temperatures="TSP.MassWeighted.STRNWeighted.temperature.mean")
CTE <- info.nests(NestsResult=resultNest_4p, 
 SexualisationTRN=fitSTRN$par, out="summary")$summary
plot_add(x=CTE$TSP.MassWeighted.STRNWeighted.temperature.mean, y=males/sexed, 
 col="red", pch=19)
legend("topright", legend=c("CTE with Sexualisation TRN"), 
pch=19, col=c("red"))
plotR(parameters=fitSTRN$par, main="Sexualisation TRN")
# Initial_STRN <- resultNest_4p$par
Initial_STRN <- structure(c(4230.10750319997, 510.543319171189, 1015.78663983953,
118.189709917707), .Names = c("DHA", "DHH", "T12H", "Rho25"))
males <- c(7, 0, 0, 0, 0, 5, 6, 3, 5, 3, 2, 3, 0, 0, 0, 0, 0, 0, 0, 0, NA)
names(males) <- rev(rev(names(resultNest_4p$data))[-(1:2)])
sexed <- c(rep(10, length(males)-1), NA)
names(sexed) <- rev(rev(names(resultNest_4p$data))[-(1:2)])
fitSTRN <- STRN(Initial_STRN, EmbryoGrowthTRN=resultNest_4p, tsd=Med_Cc, 
Sexed=sexed, Males=males, 
Temperatures="TSP.MassWeighted.STRNWeighted.temperature.mean")
CTE <- info.nests(NestsResult=resultNest_4p, 
SexualisationTRN=fitSTRN$par, out="summary")$summary
plot(Med_Cc, xlim=c(25, 35))
plot_add(x=CTE$TSP.MassWeighted.STRNWeighted.temperature.mean, y=males/sexed, 
col="red", pch=19)
legend("topright", legend=c("CTE with Sexualisation TRN"), 
pch=19, col=c("red"))
plotR(parameters=fitSTRN$par, main="Sexualisation TRN")
}
}
\author{
Marc Girondot
}

