% Generated by roxygen2 (4.0.1): do not edit by hand
\name{tune}
\alias{detune}
\alias{is.tunable}
\alias{is.tuned}
\alias{tune}
\title{Tune parameters of modeling procedures}
\usage{
tune(proc, ..., .retune = FALSE, .verbose = FALSE)

is.tuned(proc)

is.tunable(proc)

detune(proc)
}
\arguments{
\item{proc}{modeling procedure, or list of modeling procedures, as
produced by \code{\link{modeling.procedure}}.}

\item{...}{Sent to \code{\link{batch.model}}.}

\item{.retune}{Whether to retune already tuned processes.}

\item{.verbose}{Whether to print an activity log.}
}
\value{
A tuned modeling procedures or a list of such.

Logical indicating if the procedure(s) are tuned.

Logical indicating if the has tunable parameters.

A list of untuned modeling procedures.
}
\description{
These functions are rarely needed to be called manually as they are
automatically called by \code{\link{fit}} and \code{\link{evaluate.modeling}}
when needed.
}
\examples{
proc <- modeling.procedure("randomForest", param=list(mtry=1:4))
tuned.proc <- tune(proc, x=iris[-5], y=iris$Species)
mod <- fit(tuned.proc, x=iris[-5], y=iris$Species)
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}
\seealso{
\code{\link{emil}}, \code{\link{modeling.procedure}},
  \code{\link{evaluate.modeling}}, \code{\link{fit}},
  \code{\link[=predict.modeling.procedure]{predict}}, \code{\link{vimp}}
}

