% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/resampling.r
\name{subresample}
\alias{subresample}
\title{Generate resampling subschemes}
\usage{
subresample(fold, y = length(fold))
}
\arguments{
\item{fold}{A resampling scheme or fold to use to define the sub scheme(s).}

\item{y}{The observations used to create the resampling scheme. See
\code{\link{resample}} for details.}
}
\value{
A resampling scheme.
}
\description{
A subscheme is a resampling scheme that only includes observations in the
training set of an original scheme. This function
automatically fetches the type and parameters of the prototype and use them
to generate the subscheme.
}
\examples{
cv <- resample("holdout", y=12, fraction=1/4, nfold=3)
inner.cv <- subresample(cv, y=12)
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}
\seealso{
\code{\link{emil}}, \code{\link{resample}}
}

