% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.r
\name{get_color}
\alias{get_color}
\alias{get_color.default}
\alias{get_color.factor}
\title{Get color palettes}
\usage{
get_color(x, ...)

\method{get_color}{default}(x, s, v, alpha, ...)

\method{get_color}{factor}(x, levels = FALSE, col = "Set1", ...)
}
\arguments{
\item{x}{Character vector of colors or factor of class memberships to
generate colors for.}

\item{...}{Sent to \code{\link{get_color.default}}.}

\item{s}{Saturation. \code{s = 0} leaves it unchanged, \code{0 < s <= 1}
increases, and \code{-1 <= s < 0} decreases.}

\item{v}{Value. \code{s = 0} leaves it unchanged, \code{0 < s <= 1}
increases, and \code{-1 <= s < 0} decreases.}

\item{alpha}{Transparency.}

\item{levels}{If \code{TRUE} a palette with one color per level of \code{x}
is returned. If \code{FALSE} one color per element in \code{x} is returned.}

\item{col}{Color palette with one color per class or the name of the color
brewer palette to use, see \code{name} argument of \code{\link[RColorBrewer]{brewer.pal}}
for a list of possible values.}
}
\value{
A character vector of hex colors.
}
\description{
Can be used to modify an existing palette, e.g. change brightness,
or to generate a palette for a response vector.
}
\author{
Christofer \enc{Bäcklin}{Backlin}
}

