\name{mu.colour}
\alias{mu.colour}

\title{ Function for specifying color, linetype, and line-widths in
EMU plotting functions.  }
\description{
   The function specifies color, linetype and linewidths
in EMU plotting functions as is used mostly in calls
from within plot.trackdata, plot.spectral, eplot, and dplot
}
\usage{
mu.colour(labs, col = TRUE, linetype = FALSE, lwd = NULL)
}

\arguments{
  \item{labs}{ A vector of character labels }
  \item{col}{ A code passed to the 'col'
argument in plotting functions. There are four possibilities. Either
logical, a character vector, or a numeric vector.
In the first case, if TRUE, then a different numeric
code is given for each unique label type. For example,
if labs is c("a", "b", "a", "c"), then
the output is c(1, 2, 1, 3). If F, then for this
example, the output is c(1, 1, 1, 1). In
the second case, the character vector can be
either a single element specifying a character,
or there can be as many elements as there are
unique colors. Thus if col = "red", then
for the example c("a", "b", "a", "c"), the output
is c("red", "red", "red", "red). Alternatively,
since there are three unique labels for this example,
then the user could specify col = c("green", "red", "blue")
and the output is c("green", "red", "green", "blue")
if labs is c("a", "b", "a", "c"). 
In the third case, 'col'. can be either
a single element numeric vector, or its length must
be equal to the number of unique types in labs.
For example, if col=3 and if labs = c("a", "b", "a", "c"),
then the output is c(3, 3, 3, 3). Alternatively,
if col = c(2,3,1), then the output is
c(2, 3, 2, 1) for the same example. Finally, 
col can be specified as a character or numeric
vector that is the same length as labs, allowing the
user to choose the color in which each line should be drawn.
The default is col = TRUE.

 }
  \item{linetype}{ A code specifying
linetypes, i.e. the values passed to lty
in plotting functions.There are 2 possibilities.
Either
logical, a character vector, or a numeric vector.
In the first case, if TRUE, then a different numeric
code is given for each unique label type. For example,
if labs is c("a", "b", "a", "c"), then
the output is c(1, 2, 1, 3). If F, then for this
example, the output is c(1, 1, 1, 1). 
In the second case, 'linetype' can be either
a single element numeric vector, or its length must
be equal to the number of unique types in labs.
For example, if linetype=3 and if labs = c("a", "b", "a", "c"),
then the output is c(3, 3, 3, 3). Alternatively,
if linetype = c(2,3,1), then the output is
c(2, 3, 2, 1) for the same example. Finally, 
linetype can be specified as a  numeric
vector that is the same length as labs, allowing the
user to choose the linetype in which each line should be drawn.
The default is linetype=F
 }
  \item{lwd}{ A code passed to the lwd argument
in plotting functions.
'lwd' can be either
a single element numeric vector, or its length must
be equal to the number of unique types in labs.
For example, if lwd=3 and if labs = c("a", "b", "a", "c"),
then the output is c(3, 3, 3, 3). Alternatively,
if lwd = c(2,3,1), then the output is
c(2, 3, 2, 1) for the same example. The default is
NULL in which case all lines are drawn with lwd=1  }
}
\details{
   Parameters are also supplied for use with the function 'legend' 
}
\value{
  If it is a LISTRUE, use
  \item{colour }{A code for the color'}
  \item{linetype }{A code for the linetype}
\item{lwd} {A code for the line width}
\item{legend} {A list consisting of \$legend\$lab, 
\$legend\$lty and \$legend\$lwd that specify
the parameters for the 'legend' function.

  ...
}
}

\author{ Steve Cassidy modified by Jonathan Harrington }

\seealso{ 
\code{\link{plot.trackdata}}
\code{\link{dplot}}
\code{\link{eplot}}
\code{\link{plot.spectral}} 
}


\examples{
# examples will be given using the above functions
# b/w but with different linetypes
eplot(vowlax.fdat.5[,1:2], vowlax.l, col=FALSE, linetype=TRUE)

# user-defined colors
eplot(vowlax.fdat.5[,1:2], vowlax.l, col=c("green", "blue", "red", "orange"))

# spectral plot, user-defined colors, the last one is dotted
# and with a line-thickness of 2
plot(vowlax.dft.5[1:20,], vowlax.l[1:20], 
col=c("green", "blue", "red", "orange"), 
fun=mean, lty=c(1, 1, 1, 2), lwd=c(1, 1, 1, 2))

# similar but using dplot()
dplot(vowlax.fdat[1:20,2], vowlax.l, 
col=c("green", "blue", "red", "orange"), 
lwd=c(1, 1, 1, 2), linetype=c(1, 1, 1, 2))

# the default except plot everything with a dotted line
dplot(vowlax.fdat[,2], vowlax.l, average=TRUE, linetype=2)

# the default except plot everything with a dotted line and
# with double line thickness
eplot(vowlax.fdat.5[,1:2], vowlax.l, linetype=2, lwd=2)
}



\keyword{utilities}