% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/emuR-convert_txtCollection.R
\name{convert_txtCollection}
\alias{convert_txtCollection}
\title{Converts a collection of audio files and plain text transcriptions into an emuDB}
\usage{
convert_txtCollection(dbName, sourceDir, targetDir, txtExtension = "txt",
  mediaFileExtension = "wav",
  attributeDefinitionName = "transcription", cleanWhitespaces = TRUE,
  verbose = TRUE)
}
\arguments{
\item{dbName}{name of the new emuDB}

\item{sourceDir}{directory containing the plain text transcription files and media files}

\item{targetDir}{directory where the new emuDB will be stored}

\item{txtExtension}{file extension of transcription files}

\item{mediaFileExtension}{file extension of media files}

\item{attributeDefinitionName}{label name of the transcription items}

\item{cleanWhitespaces}{if true, any sequence of whitespaces in the transcription (including newlines and tabs)
is transformed into a single blank}

\item{verbose}{display progress bar}
}
\description{
This function takes as input pairs of media files (i.e. wav files) and plain text
transcriptions files. It creates a new emuDB with one bundle per media file, and
turns the associated transcription into an item in that bundle. For this purpose,
media files and text files belonging to the same bundle must be named identically
(with the exception of their respective file extensions). The newly created
emuDB is stored in the target directory, and its handle is returned.
}
\seealso{
convert_BPFCollection, convert_TextGridCollection
}
