\name{vdetect}

\alias{vdetect}

\title{Valley detection and centroidization}

\description{Checks envelopes calculated by \code{\link[enviPat]{envelope}} for valleys and extracts centroids or intensoids.}

\usage{vdetect(profiles,detect="centroid",plotit=TRUE,verbose=TRUE)}


\arguments{

  	\item{profiles}{List of stick profiles as generated by \code{\link[enviPat]{envelope}}.}

	\item{detect}{To return either \code{"centroid"}, \code{"intensoid"} or \code{"valley"}.}

	\item{plotit}{Should results be plotted, \code{TRUE/FALSE}?}
	
	\item{verbose}{Verbose, \code{TRUE/FALSE}?}

}


\section{definitions}{

	Valley: local profile minimum, i.e. any envelope stick flanked by two other sticks of higher abundance. 

	Stick: see \code{\link[enviPat]{envelope}}.

	Centroid mass: intensity-weighted sum of the m/z of sticks between two valleys. 

	Centroid intensity: profile area between two valleys (mean of upper and lower sum of stick intensities),
		normalized to the maximum centroid area of the envelope.

	Intensoid mass: m/z of the most intense stick between two valleys.

	Intensoid intensity: intensity of the most intensive stick between two valleys, normalized to the most intense intensoid.

}

\value{
List with length equal to length of list \code{profiles}, with equal names of list entries.
Each entry in that list contains the centroids, intensoids or valleys of the envelope in two columns:
	\item{m/z}{m/z}
	\item{abundance}{Area (centroid) or abundance (intensoid, valley)}
}

\author{Martin Loos, Christian Gerber}

\note{Too low stick discretization leads to imprecision in valley, centroid and intensoid characteristics.}


\seealso{
	\code{\link[enviPat]{isopattern}}
	\code{\link[enviPat]{envelope}}
}

\examples{
############################
# batch of chemforms #######
data(isotopes)
data(chemforms)
chemforms<-chemforms[1:5]

pattern<-isopattern(
  isotopes,
  chemforms,
  threshold=0.1,
  plotit=TRUE,
  charge=FALSE,
  emass=0.00054858,
  algo=2
)

profiles<-envelope(
    pattern,
    ppm=FALSE,
    dmz=0.0001,   
    frac=1/4,
    env="Gaussian",
    resolution=1E6,
    plotit=TRUE
)

centro<-vdetect(
  profiles,
  detect="centroid",
  plotit=TRUE
)

############################

}

