% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ergm.utility.R
\name{degreedist}
\alias{degreedist}
\alias{degreedist.network}
\title{Computes and Returns the Degree Distribution Information for a Given Network}
\usage{
degreedist(object, ...)

\method{degreedist}{network}(object, print = TRUE, ...)
}
\arguments{
\item{object}{a \code{network} object or some other object for
which degree distribution is meaningful.}

\item{\dots}{Additional arguments to functions.}

\item{print}{logical, whether to print the degree distribution.}
}
\value{
If directed, a matrix of the distributions of in and out
degrees; this is row bound and only contains degrees for which
one of the in or out distributions has a positive count.  If
bipartite, a list containing the degree distributions of b1 and
b2.  Otherwise, a vector of the positive values in the degree
distribution
}
\description{
The \code{degreedist} generic computes and returns the degree
distribution (number of vertices in the network with each degree
value) for a given network. This help page documents the
function. For help about \link[=degreedist-constraint]{the ERGM sample space constraint with that name}, try
\code{help("degreedist-constraint")}.
}
\section{Methods (by class)}{
\itemize{
\item \code{network}: Method for \code{\link{network}} objects.
}}

\examples{

data(faux.mesa.high)
degreedist(faux.mesa.high)

}
