% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InitErgmConstraint.blockdiag.R
\name{blockdiag-ergmConstraint}
\alias{blockdiag-ergmConstraint}
\alias{InitErgmConstraint.blockdiag}
\title{Block-diagonal structure constraint}
\usage{
# blockdiag(attr)
}
\arguments{
\item{attr}{a vertex attribute specification (see Specifying Vertex attributes and Levels (\code{?nodal_attributes}) for details.)}
}
\description{
Force a block-diagonal structure (and its bipartite analogue) on
the network. Only dyads \eqn{(i,j)} for which
\code{attr(i)==attr(j)} can have edges.

Note that the current implementation requires that blocks be
contiguous for unipartite graphs, and for bipartite
graphs, they must be contiguous within a partition and must have
the same ordering in both partitions. (They do not, however,
require that all blocks be represented in both partitions, but
those that overlap must have the same order.)

If multiple block-diagonal constraints are given, or if
\code{attr} is a vector with multiple attribute names, blocks
will be constructed on all attributes matching.
}
\seealso{
\code{\link{ergmConstraint}} for index of constraints and hints currently visible to the package.

\Sexpr[results=rd,stage=render]{ergm:::.formatTermKeywords("ergmConstraint", "blockdiag", "subsection")}
}
\concept{directed}
\concept{dyad-independent}
\concept{undirected}
