% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/tidy_eurostat.R
\name{tidy_eurostat}
\alias{tidy_eurostat}
\title{Transform raw Eurostat data table into the row-column-value format (RCV).}
\usage{
tidy_eurostat(dat, time_format = "date")
}
\arguments{
\item{dat}{a data.frame from \code{\link{get_eurostat_raw}}.}

\item{time_format}{a string giving a type of the conversion of the
                   time column from the eurostat format.
              A "date" (default) convers to a \code{\link{Date}}
              with a first date of the period. A "date_last"
              convers to a \code{\link{Date}} with
        a last date of the period. A "num" convers to a numeric and "raw"
        does not do conversion. See \code{\link{eurotime2date}} and
        \code{\link{eurotime2num}}.}
}
\value{
data.frame in the molten format with the last column 'values'.
}
\description{
Transform raw Eurostat data table into the row-column-value format (RCV).
}
\author{
Przemyslaw Biecek, Leo Lahti and Janne Huovari \email{ropengov-forum@googlegroups.com} \url{http://github.com/ropengov/eurostat}
}
\references{
See citation("eurostat").
}
\seealso{
\code{\link{get_eurostat}}
}
\keyword{database}
\keyword{internal}
\keyword{utilities}

