% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bpec.R
\name{bpec}
\alias{bpec}
\title{Belief Peak Evidential Clustering (BPEC)}
\usage{
bpec(
  x,
  g,
  type = "full",
  pairs = NULL,
  Omega = TRUE,
  alpha = 1,
  beta = 2,
  delta = 10,
  epsi = 0.001,
  disp = TRUE,
  distance = 1,
  m0 = NULL
)
}
\arguments{
\item{x}{input matrix of size n x d, where n is the number of objects and d the number of
attributes.}

\item{g}{Matrix of size c x d of prototypes (the belief peaks).}

\item{type}{Type of focal sets ("simple": empty set, singletons and Omega;
"full": all \eqn{2^c} subsets of \eqn{\Omega}; "pairs": \eqn{\emptyset}, singletons,
\eqn{\Omega}, and all
or selected pairs).}

\item{pairs}{Set of pairs to be included in the focal sets; if NULL, all pairs are
included. Used only if type="pairs".}

\item{Omega}{Logical. If TRUE (default), the whole frame is included (for types 'simple' and
'pairs').}

\item{alpha}{Exponent of the cardinality in the cost function.}

\item{beta}{Exponent of masses in the cost function.}

\item{delta}{Distance to the empty set.}

\item{epsi}{Minimum amount of improvement.}

\item{disp}{If TRUE (default), intermediate results are displayed.}

\item{distance}{Type of distance use: 0=Euclidean, 1=Mahalanobis.}

\item{m0}{Initial credal partition. Should be a matrix with n rows and a number of
columns equal to the number f of focal sets specified by 'type' and 'pairs'.}
}
\value{
The credal partition (an object of class \code{"credpart"}).
}
\description{
\code{bpec} computes a credal partition from a matrix of attribute data using the
Belief Peak Evidential Clustering (BPEC) algorithm.
}
\details{
BPEC is identical to ECM, except that the prototypes are computed from delta-Bel graph using function
\code{delta_Bel}. The ECM algorithm is then run keeping the prototypes fixed. The distance to the 
prototypes can be the Euclidean disatnce or it can be an adaptive Mahalanobis distance as in the CECM
algorithm.
}
\examples{
## Clustering of the Four-class dataset
\dontrun{
data(fourclass)
x<-fourclass[,1:2]
y<-fourclass[,3]
DB<-delta_Bel(x,100,0.9)
plot(x,pch=".")
points(DB$g0,pch=3,col="red",cex=2)
clus<-bpec(x,DB$g0,type='pairs',delta=3,distance=1)
plot(clus,x,mfrow=c(2,2))
}
}
\references{
Z.-G. Su and T. Denoeux. BPEC: Belief-Peaks Evidential Clustering. IEEE Transactions 
on Fuzzy Systems, 27(1):111-123, 2019.
}
\seealso{
\code{\link{ecm}}, \code{\link{cecm}}, \code{\link{delta_Bel}}
}
\author{
Thierry Denoeux.
}
