% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_hard_credpart.R
\name{create_hard_credpart}
\alias{create_hard_credpart}
\title{Creation of a "credpart" object from a vector of class labels}
\usage{
create_hard_credpart(y)
}
\arguments{
\item{y}{A vector of class labels.}
}
\value{
An object of class "credpart".
}
\description{
\code{create_hard_credpart} creates a "credpart" object from a vector of class labels.
}
\examples{
\dontrun{
data(fourclass)
y<-kmeans(fourclass[,1:2],4)$cluster
clus<-create_hard_credpart(y)
summary(clus)
}
}
\references{
T. Denoeux, S. Li and S. Sriboonchitta. Evaluating and Comparing Soft Partitions: an 
 Approach Based on Dempster-Shafer Theory. IEEE Transactions on Fuzzy Systems, 
 26(3):1231-1244, 2018.
}
\seealso{
\code{\link{extractMass}}, \code{\link{create_fuzzy_credpart}}
}
