/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.interpolation;

import org.apache.commons.math3.analysis.interpolation.BicubicSplineInterpolatingFunction;
import org.apache.commons.math3.analysis.interpolation.BicubicSplineInterpolator;
import org.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math3.exception.DimensionMismatchException;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.optimization.fitting.PolynomialFitter;
import org.apache.commons.math3.optimization.general.GaussNewtonOptimizer;
import org.apache.commons.math3.util.MathArrays;

public class SmoothingPolynomialBicubicSplineInterpolator
extends BicubicSplineInterpolator {
    private final PolynomialFitter xFitter;
    private final PolynomialFitter yFitter;

    public SmoothingPolynomialBicubicSplineInterpolator() {
        this(3);
    }

    public SmoothingPolynomialBicubicSplineInterpolator(int degree) {
        this(degree, degree);
    }

    public SmoothingPolynomialBicubicSplineInterpolator(int xDegree, int yDegree) {
        this.xFitter = new PolynomialFitter(xDegree, new GaussNewtonOptimizer(false));
        this.yFitter = new PolynomialFitter(yDegree, new GaussNewtonOptimizer(false));
    }

    public BicubicSplineInterpolatingFunction interpolate(double[] xval, double[] yval, double[][] fval) {
        int i;
        if (xval.length == 0 || yval.length == 0 || fval.length == 0) {
            throw new NoDataException();
        }
        if (xval.length != fval.length) {
            throw new DimensionMismatchException(xval.length, fval.length);
        }
        int xLen = xval.length;
        int yLen = yval.length;
        for (int i2 = 0; i2 < xLen; ++i2) {
            if (fval[i2].length == yLen) continue;
            throw new DimensionMismatchException(fval[i2].length, yLen);
        }
        MathArrays.checkOrder(xval);
        MathArrays.checkOrder(yval);
        PolynomialFunction[] yPolyX = new PolynomialFunction[yLen];
        for (int j = 0; j < yLen; ++j) {
            this.xFitter.clearObservations();
            for (int i3 = 0; i3 < xLen; ++i3) {
                this.xFitter.addObservedPoint(1.0, xval[i3], fval[i3][j]);
            }
            yPolyX[j] = new PolynomialFunction(this.xFitter.fit());
        }
        double[][] fval_1 = new double[xLen][yLen];
        for (int j = 0; j < yLen; ++j) {
            PolynomialFunction f = yPolyX[j];
            for (i = 0; i < xLen; ++i) {
                fval_1[i][j] = f.value(xval[i]);
            }
        }
        PolynomialFunction[] xPolyY = new PolynomialFunction[xLen];
        for (int i4 = 0; i4 < xLen; ++i4) {
            this.yFitter.clearObservations();
            for (int j = 0; j < yLen; ++j) {
                this.yFitter.addObservedPoint(1.0, yval[j], fval_1[i4][j]);
            }
            xPolyY[i4] = new PolynomialFunction(this.yFitter.fit());
        }
        double[][] fval_2 = new double[xLen][yLen];
        for (i = 0; i < xLen; ++i) {
            PolynomialFunction f = xPolyY[i];
            for (int j = 0; j < yLen; ++j) {
                fval_2[i][j] = f.value(yval[j]);
            }
        }
        return super.interpolate(xval, yval, fval_2);
    }
}

