% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{ggind}
\alias{ggind}
\alias{ggind.MCA}
\title{Graphical representation of indivduals (rows) of a multivariate analysis}
\usage{
ggind(obj, ...)

\method{ggind}{MCA}(obj, xax = 1, yax = 2, fac = NA, label = NULL,
  alpha = 0.5, palette = "Set1", ...)
}
\arguments{
\item{obj}{a multivariate analysis results object. Currently only MCA is supported}

\item{...}{arguments passed to other methods}

\item{xax}{number of the x axis}

\item{yax}{number of the y axis}

\item{fac}{an optional factor by which points are colored, and confidence ellipses drawn}

\item{label}{legend title}

\item{alpha}{points opacity}

\item{palette}{palette for points coloring, if \code{fac} is not \code{NULL}}
}
\description{
This function displays a graphical representation of the individuals (rows) of a multivariate analysis.

This function displays a graphical representation of the individuals
(rows) of a multiple correspondence analysis generated by the \code{MCA}
function of the \code{FactoMineR} package.
}
