% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{logvartimeplot}
\alias{logvartimeplot}
\title{Plot log-variances over time.}
\usage{
logvartimeplot(x, fsvsimobj = NULL, show = "both", maxrows = 5)
}
\arguments{
\item{x}{Object of class \code{'fsvdraws'}, usually resulting from a call
to \code{\link{fsvsample}}.}

\item{fsvsimobj}{To indicate data generating values in case of simulated
data, pass an object of type \code{fsvsim} (usually the result of a
call to \code{\link{fsvsim}}).}

\item{show}{If set to "fac", only factor log-volatilities will be displayed.
If set to "idi", only idiosyncratic log-volatilities will be displayed.
If set to "both", factor log-volatilities will be drawn first, followed
by the idiosyncratic log-volatilities.}

\item{maxrows}{Indicates the maximum number of rows to be drawn per page.}
}
\value{
Returns \code{x} invisibly.
}
\description{
\code{logvartimeplot} plots the idiosyncratic and factor log-variances over time.
}
\details{
This function displays the posterior distribution (\code{mean +/- 2sd})
of log-variances of both
the factors and the idiosyncratic series.
If these haven't been stored during
sampling, \code{logvartimeplot} produces an error.
}
\seealso{
Other plotting: 
\code{\link{comtimeplot}()},
\code{\link{corimageplot}()},
\code{\link{corplot}()},
\code{\link{cortimeplot}()},
\code{\link{facloadcredplot}()},
\code{\link{facloaddensplot}()},
\code{\link{facloadpairplot}()},
\code{\link{facloadpointplot}()},
\code{\link{facloadtraceplot}()},
\code{\link{paratraceplot}()},
\code{\link{plot.fsvdraws}()},
\code{\link{plotalot}()},
\code{\link{voltimeplot}()}
}
\concept{plotting}
