% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities_other.R
\name{preorder}
\alias{preorder}
\title{Ad-hoc methods for determining the order of variables}
\usage{
preorder(
  dat,
  factors = ledermann(ncol(dat)),
  type = "fixed",
  transload = identity
)
}
\arguments{
\item{dat}{Matrix containing the data, with \code{n} rows
(points in time) and \code{m} columns (component series).}

\item{factors}{Number of factors to be used, defaults to the
Ledermann bound.}

\item{type}{Can be "fixed" or "dynamic". The option "fixed"
means that that a \code{factors}-factor model is fit once and
the entire ordering is determined according to this fit
(the default). The option "dynamic" means that 
the model is re-fit \code{factors} times with the number of
factors going from 1 to
\code{factors} and in each round the correspondingly largest
loading is chosen.}

\item{transload}{Function for transforming the estimated
factor loadings before ordering. Defaults to the identity
function.}
}
\value{
A vector of length \code{m} with the ordering found.
}
\description{
In factor SV models, the ordering of variables is often
chosen through a preliminary static factor analysis. These
methods are implemented in \code{preorder}.
After a maximum likelihood factor model fit to the data,
factor loadings are ordered as follows: The variable with the
highest loading on factor 1 is placed first, the variable with
the highest loading on factor 2 second (unless this variable
is already placed first, in which case the variable with the
second highest loading is taken).
}
\seealso{
ledermann
}
