/*
 * Decompiled with CFR 0.152.
 */
package jfm.r;

import java.util.ArrayList;
import jfm.lp.LPX;
import jfm.model.BadModelException;
import jfm.model.GLPKException;
import jfm.mou.FarmerMOU;
import jfm.r.FarmRepresentation;
import jfm.r.SimpleFarmRepresentation;
import jfm.utils.JFMMath;
import jfm.utils.MathPrint;

public class CompositeFarmRepresentation
extends FarmRepresentation {
    private final double solutionThreshold;
    private int isSolved = 0;
    private ArrayList<SimpleFarmRepresentation> farmObjects = new ArrayList();
    private ArrayList<Double> weights = new ArrayList();
    private ArrayList<Double> soils = new ArrayList();
    private ArrayList<Double> rainfall = new ArrayList();

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("Composite Farm with " + this.farmObjects.size() + " farms");
        for (SimpleFarmRepresentation f : this.farmObjects) {
            buff.append(f.toString());
        }
        return buff.toString();
    }

    public CompositeFarmRepresentation() {
        this.solutionThreshold = 0.5;
    }

    public CompositeFarmRepresentation(double st) {
        this.solutionThreshold = st;
    }

    public void fixAreaOfCrop(double areaLimit, String xmlCropName) {
        for (SimpleFarmRepresentation farmObject : this.farmObjects) {
            farmObject.fixAreaOfCrop(areaLimit, xmlCropName);
        }
    }

    public void lowerLimitAreaOfCrop(double areaLimit, String xmlCropName) {
        for (SimpleFarmRepresentation farmObject : this.farmObjects) {
            farmObject.lowerLimitAreaOfCrop(areaLimit, xmlCropName);
        }
    }

    public void boundLimitAreaOfCrop(double areaMin, double areaMax, String xmlCropName) {
        for (SimpleFarmRepresentation farmObject : this.farmObjects) {
            farmObject.boundLimitAreaOfCrop(areaMin, areaMax, xmlCropName);
        }
    }

    public void setInputCost(String xmlInputName, double unitCost) {
        for (SimpleFarmRepresentation farmObject : this.farmObjects) {
            farmObject.setInputCost(xmlInputName, unitCost);
        }
    }

    public void reset() {
        for (SimpleFarmRepresentation farmObject : this.farmObjects) {
            farmObject.reset();
        }
    }

    public void setYieldForCrop(String xmlCropName, double yield) {
        for (SimpleFarmRepresentation farmObject : this.farmObjects) {
            farmObject.setYieldForCrop(xmlCropName, yield);
        }
    }

    public void setPriceForCrop(String xmlCropName, double price) {
        for (SimpleFarmRepresentation farmObject : this.farmObjects) {
            farmObject.setPriceForCrop(xmlCropName, price);
        }
    }

    public void setSubsidyForCrop(String xmlCropName, double subsidy) {
        for (SimpleFarmRepresentation farmObject : this.farmObjects) {
            farmObject.setSubsidyForCrop(xmlCropName, subsidy);
        }
    }

    public void addFarm(SimpleFarmRepresentation farm, double soil, double rainfall_, double weight) {
        farm.setSoilTypeAndRainfall(soil, rainfall_);
        this.farmObjects.add(farm);
        this.weights.add(weight);
        this.soils.add(soil);
        this.rainfall.add(rainfall_);
    }

    public void applyMOU(FarmerMOU mou) {
        for (SimpleFarmRepresentation f : this.farmObjects) {
            f.applyMOU(mou);
        }
    }

    public void createAndApplyMOU(String mouName) {
        FarmerMOU mou = FarmerMOU.fromXML(mouName);
        this.applyMOU(mou);
    }

    public int isSolved() {
        return this.isSolved;
    }

    public double profit() {
        double weightedProfit = 0.0;
        for (int i = 0; i < this.farmObjects.size(); ++i) {
            weightedProfit += this.weights.get(i) * this.farmObjects.get(i).profit();
        }
        return weightedProfit;
    }

    public String solver() {
        return this.farmObjects.get(0).solver();
    }

    public double eo() {
        double weightedeo = 0.0;
        for (int i = 0; i < this.farmObjects.size(); ++i) {
            weightedeo += this.weights.get(i) * this.farmObjects.get(i).eo();
        }
        return weightedeo;
    }

    public String[] cropNames() {
        return this.farmObjects.get(0).cropNames();
    }

    public String[] objectiveNames() {
        return this.farmObjects.get(0).objectiveNames();
    }

    public double[] objectiveValues() {
        double[] weightedvalues = new double[this.objectiveNames().length];
        JFMMath.doubleZero(weightedvalues);
        for (int i = 0; i < this.farmObjects.size(); ++i) {
            double[] vals = this.farmObjects.get(i).objectiveValues();
            int j = 0;
            while (j < vals.length) {
                int n = j;
                weightedvalues[n] = weightedvalues[n] + vals[j] * this.weights.get(i);
                ++i;
            }
        }
        return weightedvalues;
    }

    public double[] objectiveScaleFactors() {
        double[] weightedvalues = new double[this.objectiveNames().length];
        JFMMath.doubleZero(weightedvalues);
        for (int i = 0; i < this.farmObjects.size(); ++i) {
            double[] vals = this.farmObjects.get(i).objectiveScaleFactors();
            int j = 0;
            while (j < vals.length) {
                int n = j;
                weightedvalues[n] = weightedvalues[n] + vals[j] * this.weights.get(i);
                ++i;
            }
        }
        return weightedvalues;
    }

    public double areaOfCropNamed(String name) {
        double weightedArea = 0.0;
        for (int i = 0; i < this.farmObjects.size(); ++i) {
            weightedArea += this.weights.get(i) * this.farmObjects.get(i).areaOfCropNamed(name);
        }
        return weightedArea;
    }

    public double priceOfCropNamed(String name) {
        double weightedPrice = 0.0;
        for (int i = 0; i < this.farmObjects.size(); ++i) {
            weightedPrice += this.weights.get(i) * this.farmObjects.get(i).priceOfCropNamed(name);
        }
        return weightedPrice;
    }

    public double yieldOfCropNamed(String name) {
        double weightedYield = 0.0;
        for (int i = 0; i < this.farmObjects.size(); ++i) {
            weightedYield += this.weights.get(i) * this.farmObjects.get(i).yieldOfCropNamed(name);
        }
        return weightedYield;
    }

    public double areaOfWinterStubble() {
        double weightedArea = 0.0;
        for (int i = 0; i < this.farmObjects.size(); ++i) {
            weightedArea += this.weights.get(i) * this.farmObjects.get(i).areaOfWinterStubble();
        }
        return weightedArea;
    }

    public void setDistanceFromSugarbeetFactory(double distance, double costPerKmPerHa) {
        for (SimpleFarmRepresentation f : this.farmObjects) {
            f.setDistanceFromSugarbeetFactory(distance, costPerKmPerHa);
        }
    }

    public void solutionDetails() {
    }

    public String solutionSummary() {
        StringBuffer buff = new StringBuffer();
        String[] cnames = this.cropNames();
        if (this.isSolved() == 0) {
            buff.append("Unsolved Composite Farm with " + this.farmObjects.size() + "farms \n");
            for (int i = 0; i < cnames.length; ++i) {
                buff.append(cnames[i] + " ");
            }
            return buff.toString();
        }
        for (int i = 0; i < cnames.length; ++i) {
            buff.append(MathPrint.f2.format(this.areaOfCropNamed(cnames[i])) + " ");
        }
        buff.append("\n");
        return buff.toString();
    }

    public int solve(String failDump) {
        this.isSolved = 0;
        JFMMath.normalize(this.weights);
        LPX[] status = new LPX[this.weights.size()];
        int i = 0;
        try {
            for (SimpleFarmRepresentation f : this.farmObjects) {
                status[i] = f.farmObject.solve(false, failDump);
                ++i;
            }
        }
        catch (GLPKException ex) {
            throw new Error("GLPKException " + ex.getMessage());
        }
        catch (BadModelException ex) {
            throw new Error("BadModelException " + ex.getMessage());
        }
        double wttotal = 0.0;
        double wtmissing = 0.0;
        for (i = 0; i < status.length; ++i) {
            wttotal += this.weights.get(i).doubleValue();
            if (status[i] == LPX.LPX_OPT) continue;
            wtmissing += this.weights.get(i).doubleValue();
            this.weights.set(i, 0.0);
        }
        if (wtmissing / wttotal > this.solutionThreshold) {
            throw new Error("Weighted proportion " + wtmissing / wttotal + " of a composite farm failed to solve");
        }
        JFMMath.normalize(this.weights);
        this.isSolved = 1;
        return LPX.LPX_OPT.toCPP();
    }
}

