% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/perf.paired.roc.R
\name{perf.fbroc.paired.roc}
\alias{perf.fbroc.paired.roc}
\title{Calculate performance for paired bootstrapped ROC curves}
\usage{
\method{perf}{fbroc.paired.roc}(roc, metric = "auc", conf.level = 0.95,
  tpr = NULL, fpr = NULL, ...)
}
\arguments{
\item{roc}{An object of class \code{fbroc.paired.roc}.}

\item{metric}{A performance metric. Select "auc" for the AUC, "tpr" for the TPR at a fixed
FPR and "fpr" for the FPR at a fixed TPR.}

\item{conf.level}{The confidence level of the confidence interval.}

\item{tpr}{The fixed TPR at which the FPR is to be evaluated when \code{fpr} is selected as metric.}

\item{fpr}{The fixed FPR at which the TPR is to be evaluated when \code{tpr} is selected as metric.}

\item{...}{Further arguments, that are not used at this time.}
}
\description{
For a given metric this calculates the difference in performance between two paired predictors
stored in an object of class \code{fbroc.paired.roc} in addition to their individual performance.
}
\examples{
data(roc.examples)
example <- boot.paired.roc(roc.examples$Cont.Pred, roc.examples$Cont.Pred.Outlier,
                               roc.examples$True.Class)
perf(example, metric = "auc")
perf(example, metric = "tpr", fpr = 0.2) # Get difference in TPR at a FPR of 20\%
}

