% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecast.hybridModel.R
\name{forecast.hybridModel}
\alias{forecast.hybridModel}
\title{Hybrid forecast}
\usage{
\method{forecast}{hybridModel}(object, h = ifelse(object$frequency > 1, 2 *
  object$frequency, 10), xreg = NULL, level = c(80, 95), fan = FALSE, ...)
}
\arguments{
\item{object}{A hybrid time series model fit with hybridModel()}

\item{h}{Number of periods for forecasting. If \code{xreg} is used, \code{h} is ignored and the number of forecast 
periods is set to the number of rows of \code{xreg}.}

\item{xreg}{Future values of regression variables (for use if one of the ensemble methods used
in creating the hybrid forecast was \code{auto.arima} or \code{stlm} and a xreg was used in the fit)}

\item{level}{Confidence level for prediction intervals}

\item{fan}{If \code{TRUE}, level is set to \code{seq(51, 99, by = 3)}. This is suitable for fan plots.}

\item{...}{other arguments; currently not used.}
}
\value{
An object of class forecast.
}
\description{
Forecast method for hybrid models.
}
\details{
If \code{xreg} was used in construcing the \code{hybridModel}, it must also be passed into \code{forecast.hybridModel}
}
\examples{
\dontrun{
mod <- hybridModel(AirPassengers)
plot(forecast(mod))
}

}
\seealso{
\code{\link{hybridModel}}
}

