% Generated by roxygen2 (4.0.2): do not edit by hand
\name{zscore_img}
\alias{zscore_img}
\title{Get Z-score over a margin of an img}
\usage{
zscore_img(img, mask = NULL, margin = 3, centrality = c("mean", "median"),
  remove.na = TRUE, remove.nan = TRUE, remove.inf = TRUE,
  remove.val = 0)
}
\arguments{
\item{img}{character path of image or
an object of class nifti}

\item{mask}{character path of mask or
an object of class nifti}

\item{margin}{Margin of image to z-score over (3-Axial, 2-Sagittal,
1-Coronal)}

\item{centrality}{(character) Measure to center the data,
either mean or median}

\item{remove.na}{(logical) change NAs to remove.val}

\item{remove.nan}{(logical) change NaN to remove.val}

\item{remove.inf}{(logical) change Inf to remove.val}

\item{remove.val}{(logical) value to put the NA/NaN/Inf}
}
\value{
Array of object of class nifti
}
\description{
Standardizes an image either by the axial, sagittal, or
coronal slice
}
\examples{
dim = c(100, 30, 5)
img = array(rnorm(prod(dim), mean=4, sd=4),
dim=dim)

truth2 = img
for (i in 1:dim(img)[2]) {
truth2[,i,] = (truth2[,i,]- mean(truth2[,i,]))/sd(truth2[,i,])
}

truth1 = img
for (i in 1:dim(img)[1]) {
truth1[i,,] = (truth1[i,,]- mean(truth1[i,,]))/sd(truth1[i,,])
}

truth3 = img
for (i in 1:dim(img)[3]) {
truth3[,,i] = (truth3[,,i]- mean(truth3[,,i]))/sd(truth3[,,i])
}
try3 = zscore_img(img, margin=3)
stopifnot(all.equal(try3, truth3))
try2 = zscore_img(img, margin=2)
stopifnot(all.equal(try2, truth2))
try1 = zscore_img(img, margin=1)
stopifnot(all.equal(try1, truth1))
}
\seealso{
\link{aperm}
}

