% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsl_thresh.R, R/fslhd.R
\name{fsl_thresh}
\alias{fsl_thresh}
\alias{fslthresh}
\title{Threshold an image}
\usage{
fsl_thresh(..., outfile = tempfile(fileext = ".nii.gz"), retimg = FALSE)

fslthresh(
  file,
  outfile = NULL,
  thresh = 0,
  uthresh = NULL,
  retimg = TRUE,
  reorient = FALSE,
  intern = FALSE,
  opts = "",
  verbose = TRUE,
  ...
)
}
\arguments{
\item{...}{additional arguments passed to \code{\link{readnii}}.}

\item{outfile}{(character) name of resultant thresholded file}

\item{retimg}{(logical) return image of class nifti}

\item{file}{(character) filename of image to be thresholded}

\item{thresh}{(numeric) threshold (anything below set to 0)}

\item{uthresh}{(numeric) upper threshold (anything above set to 0)}

\item{reorient}{(logical) If retimg, should file be reoriented when read in?
Passed to \code{\link{readnii}}.}

\item{intern}{(logical) pass to \code{\link{system}}}

\item{opts}{(character) additional options to be passed to fslmaths}

\item{verbose}{(logical) print out command before running}
}
\value{
character or logical depending on intern
}
\description{
This function calls \code{fslmaths -thr -uthr} to threshold an image
and either saves the image or returns an object of class nifti
}
\note{
Functions with underscores have different defaults
and will return an output filename, so to be used for piping
}
\examples{
if (have.fsl()){
system.time({
x = array(rnorm(1e6), dim = c(100, 100, 100))
img = nifti(x, dim= c(100, 100, 100), 
datatype = convert.datatype()$FLOAT32, cal.min = min(x), 
cal.max = max(x), pixdim = rep(1, 4))
thresh = fslthresh(img, thresh=0, uthresh = 2, retimg=TRUE)
})
} 
}
