% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readrpi.R
\name{readrpi}
\alias{readrpi}
\title{Read NIfTI file reoriented to RPI}
\usage{
readrpi(file, ..., verbose = TRUE)
}
\arguments{
\item{file}{file name of the NIfTI file.}

\item{...}{Arguments to pass to \code{\link{readnii}}}

\item{verbose}{print diagnostics, passed to \code{\link{rpi_orient_file}}}
}
\description{
This function calls the \code{\link{readnii}} function after
calling \code{\link{rpi_orient_file}} to force RPI orientation.
}
\examples{
if (have.fsl()){
print(fsl_version())
in_ci <- function() {
 nzchar(Sys.getenv("CI"))
 }
 if (in_ci()) {
 destfile = tempfile(fileext = ".nii.gz")
 url = paste0("https://ndownloader.figshare.com/", 
 "files/18068546")
 old_url = paste0("https://github.com/muschellij2/", 
 "Neurohacking/files/3454385/113-01-MPRAGE2.nii.gz")
 dl = tryCatch(download.file(url,
 destfile = destfile))
 if (inherits(dl, "try-error") || dl != 0) {
 dl = download.file(old_url, destfile = destfile)
 }
 res = readrpi(destfile)
 }
 }   
}
