% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ft_cr_links.R
\name{ft_cr_links}
\alias{ft_cr_links}
\title{Get Crossref full text links from a DOI}
\usage{
ft_cr_links(doi, type = "all", ...)
}
\arguments{
\item{doi}{(character) A Digital Object Identifier (DOI). required.}

\item{type}{(character) One of 'xml', 'html', 'plain', 'pdf',
'unspecified', or 'all' (default). required.}

\item{...}{Named parameters passed on to \code{\link[crul:HttpClient]{crul::HttpClient()}}}
}
\value{
\code{NULL} if no full text links given; a list of tdmurl objects if
links found. a tdmurl object is an S3 class wrapped around a simple list,
with attributes for:
\itemize{
\item type: type, matchin type passed to the function
\item doi: DOI
\item member: Crossref member ID
\item intended_application: intended application, e.g., text-mining
}
}
\description{
Get Crossref full text links from a DOI
}
\details{
Note that this function is not vectorized.

Some links returned will not in fact lead you to full text
content as you would understandbly think and expect. That is, if you
use the \code{filter} parameter with e.g., \code{\link[rcrossref:cr_works]{rcrossref::cr_works()}}
and filter to only full text content, some links may actually give back
only metadata for an article. Elsevier is perhaps the worst offender,
for one because they have a lot of entries in Crossref TDM, but most
of the links that are apparently full text are not in fact full text,
but only metadata. You can get full text if you are part of a subscribing
institution to that specific Elsever content, but otherwise, you're SOL.

Note that there are still some bugs in the data returned form CrossRef.
For example, for the publisher eLife, they return a single URL with
content-type application/pdf, but the URL is not for a PDF, but for both
XML and PDF, and content-type can be set with that URL as either XML or
PDF to get that type.

In another example, all Elsevier URLs at time of writing are have
\code{http} scheme, while those don't actually work, so we have a
custom fix in this function for that publisher. Anyway, expect changes...
}
\section{Register for the Polite Pool}{

See of 'Authentication' setion of the \link{fulltext-package} manual page
}

\examples{
\dontrun{
dois <- c("10.1245/s10434-016-5211-6",
"10.17159/2413-3108/2016/v0i55a49", "10.17159/2413-3108/2015/v0i53a455",
"10.17159/2413-3108/2006/v0i18a982", "10.1007/s10665-016-9845-y", 
"10.1016/j.ad.2015.06.020", "10.1016/j.medipa.2014.03.002")

# pdf link
ft_cr_links(doi = "10.5555/515151", "pdf")

# xml and plain text links
ft_cr_links(dois[1], "pdf")
ft_cr_links(dois[6], "xml")
ft_cr_links(dois[7], "plain")
ft_cr_links(dois[1]) # all is the default

# pdf link
ft_cr_links(doi = "10.5555/515151", "pdf")
ft_cr_links(doi = "10.3897/phytokeys.52.5250", "pdf")

# many calls, use e.g., lapply
lapply(dois[1:3], ft_cr_links)

# elsevier
## DOI that is open acccess
ft_cr_links('10.1016/j.physletb.2010.10.049')
## DOI that is not open acccess
ft_cr_links('10.1006/jeth.1993.1066')
}
}
