% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outliers.R
\name{hampel_outlier}
\alias{hampel_outlier}
\title{Hampel Outlier Threshold}
\usage{
hampel_outlier(input, k_mad_value = 3)
}
\arguments{
\item{input}{Numeric variable vector}

\item{k_mad_value}{'K' multiplier for the median absolute deviation. The higher the value, the more outliers will be detected. Default value=3 (it's an standad)}
}
\value{
A two-item vector, the first value represents the bottom threshold, while the second one is the top threshold
}
\description{
Retrieves the bottom and top boundaries to flag outliers or extreme values, according to the Hampel method. This technique takes into account the median and MAD value, which is a is a robust measure of the variability of a univariate sample of quantitative data (Wikipedia). Similar to standard deviation but less sensitve to outliers.
This function is used in 'prep_outliers' function. All `NA`s values are automatically excluded. More information at: \url{https://livebook.datascienceheroes.com/data-preparation.html#how_to_deal_with_outliers_in_r}.
}
\examples{
\dontrun{
hampel_outlier(heart_disease$age)
}
}
