\name{faMAP}
\alias{faMAP}
\title{Velicer's minimum partial correlation method for determining the number of major components for a principal components analysis or a factor analysis}
\description{Uses Velicer's MAP (i.e., matrix of partial correlations) procedure to determine the number of components from a matrix of partial correlations.
}
\usage{
       faMAP(R, max.fac = 8, Print = TRUE, Plot = TRUE)
}
\arguments{
 \item{R}{input data in the form of a correlation matrix.}
 \item{max.fac}{maximum number of dimensions to extract.}
 \item{Print}{(logical) Print = TRUE will print complete results.}
 \item{Plot}{(logical) Plot = TRUE will plot the MAP values.}
}
\value{ 
\item{MAP}{Minimum partial correlations}
\item{MAP4}{Minimum partial correlations}
\item{fm}{average of the squared partial correlations after the first m components are partialed out.}
\item{fm4}{see Velicer, Eaton, & Fava, 2000.}
\item{PlotAvgSq}{A saved object of the original MAP plot (based on the average squared partial r's.)}
\item{PlotAvg4th}{A saved object of the revised MAP plot (based on the average 4th power of the partial r's.)}
}
\references{
Velicer, W. (1976). Determining the number of components from the matrix of partial correlations. Psychometrika, 41(3):321--327.

Velicer,W. F.,  Eaton, C. A. , & Fava, J. L. (2000). Construct explication through factor or component analysis: A review and evaluation of alternative procedures for determining the number of factors or components. In R. D. Goffin & E. Helmes (Eds.). Problems and Solutions in Human Assessment: Honoring Douglas N. Jackson at Seventy (pp. 41-71. Boston, MA: Kluwer Academic. 
}
\author{Niels Waller}
\examples{
	# Harman's data (1967, p 80) 
	# R = matrix(c(
	# 1.000,  .846,  .805,  .859,  .473,  .398,  .301,  .382,
	#  .846, 1.000,  .881,  .826,  .376,  .326,  .277,  .415,
	#  .805,  .881, 1.000,  .801,  .380,  .319,  .237,  .345,
	#  .859,  .826,  .801, 1.000,  .436,  .329,  .327,  .365,
	#  .473,  .376,  .380,  .436, 1.000,  .762,  .730,  .629,
	#  .398,  .326,  .319,  .329,  .762, 1.000,  .583,  .577,
	#  .301,  .277,  .237,  .327,  .730,  .583, 1.000,  .539,
	#  .382,  .415,  .345,  .365,  .629,  .577,  .539, 1.000), 8,8)

	  F <- matrix(c(  .4,  .1,  .0,
	                  .5,  .0,  .1,
	                  .6,  .03, .1,
	                  .4, -.2,  .0,
	                   0,  .6,  .1,
	                  .1,  .7,  .2,
	                  .3,  .7,  .1,
	                   0,  .4,  .1,
	                   0,   0,  .5,
	                  .1, -.2,  .6, 
	                  .1,  .2,  .7,
	                 -.2,  .1,  .7),12,3)
					 
	  R <- F \%*\% t(F)
	  diag(R) <- 1 
	  
  	faMAP(R, max.fac = 8, Print = TRUE, Plot = TRUE) 
}
\keyword{statistics}% at least one, from doc/KEYWORDS
