% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distinctiveness_alt.R
\name{distinctiveness_alt}
\alias{distinctiveness_alt}
\title{Other Functional Distinctiveness within range}
\usage{
distinctiveness_alt(pres_matrix, dist_matrix, given_range)
}
\arguments{
\item{pres_matrix}{a site-species matrix (presence-absence or relative
abundances), with sites in rows and species in columns}

\item{dist_matrix}{a species functional distance matrix}

\item{given_range}{a numeric indicating the dissimilarity range at which the
the other species are considered maximally dissimilar}
}
\value{
a similar matrix from provided \code{pres_matrix} with Distinctiveness
values in lieu of presences or relative abundances, species absent from
communities will have an \code{NA} value (see \code{Note} section)
}
\description{
Computes functional distinctiveness from a site-species matrix (containing
presence-absence or relative abundances) of species with provided functional
distance matrix \strong{considering only species within a given range in the
functional space}. The sites-species matrix should have \strong{sites} in
\strong{rows} and \strong{species} in \strong{columns}, similar to
\pkg{vegan} package defaults.
}
\details{
The Functional Distinctiveness of a species is the average functional
distance from a species to all the other in the given community. It is
computed as such:
\deqn{
   D_i(T) = \frac{
                \sum\limits_{j = 1 ~,j \neq i ~}^S
                \left[ \frac{d_{ij}}{T} + \theta(d_{ij} - T)
                  \left(1 - \frac{d_{ij}}{T} \right) \right]
              }{
                S - 1
              }
   }{%
   D_i (T) = \Sigma_(j = 0, j != i)^N [d_ij/T  + \theta(d_ij - T)
                                       (1 - d_ij/T)] / S - 1

   }
with \eqn{D_i} the functional distinctiveness of species \eqn{i}, \eqn{N}
the total number of species in the community and \eqn{d_{ij}}{d_ij} the
functional distance between species \eqn{i} and species \eqn{j}. \eqn{T}
is the chosen maximal range considered. The function
\eqn{\theta(d_ij - T)} is an indicator function that returns 1 when
\eqn{d_{ij} \geq T}{d_ij ≥ T} and 0 when \eqn{d_{ij} < T}{d_ij < T}.
\strong{IMPORTANT NOTE}: in order to get functional rarity indices between 0
and 1, the distance metric has to be scaled between 0 and 1.
}
\section{Note}{

Absent species should be coded by \code{0} or \code{NA} in input matrices.

When a species is alone in its community the functional distinctiveness
cannot be computed (denominator = 0 in formula), and its value is assigned
as \code{NaN}.

For speed and memory efficiency sparse matrices can be used as input of
the function using \code{as(pres_matrix, "sparseMatrix")} from the
\code{Matrix} package.
(see \code{vignette("sparse_matrices", package = "funrar")})
}

