% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/availableWorkers.R
\name{availableWorkers}
\alias{availableWorkers}
\title{Get set of available workers}
\usage{
availableWorkers(methods = getOption("future.availableWorkers.methods",
  c("mc.cores", "_R_CHECK_LIMIT_CORES_", "PBS", "SGE", "Slurm", "system",
  "fallback")), na.rm = TRUE, default = "localhost",
  which = c("auto", "min", "max", "all"))
}
\arguments{
\item{methods}{A character vector specifying how to infer the number
of available cores.}

\item{na.rm}{If TRUE, only non-missing settings are considered/returned.}

\item{default}{The default set of workers.}

\item{which}{A character specifying which set / sets to return.
If \code{"auto"}, the first non-empty set found.
If \code{"min"}, the minimum value is returned.
If \code{"max"}, the maximum value is returned (be careful!)
If \code{"all"}, all values are returned.}
}
\value{
Return a character vector of workers, which typically consists
of names of machines / compute nodes, but may also be IP numbers.
}
\description{
Get set of available workers
}
\details{
The default set of workers for each method is
\code{rep("localhost", times = availableCores(method))}, which means
that each will at least use as many parallel workers on the current
machine that \code{\link{availableCores}()} allows for that method.

In addition, the following settings ("methods") are also acknowledged:
\itemize{
 \item \code{"PBS"} -
   Query TORQUE/PBS environment variable \env{PBS_NODEFILE}.
   If this is set and specifies an existing file, then the set
   of workers is read from that file, where one worker (node)
   is given per line.
   An example of a job submission that results in this is
   \code{qsub -l nodes = 4:ppn = 2}, which requests four nodes each
   with two cores.
 \item \code{"SGE"} -
   Query Sun/Oracle Grid Engine (SGE) environment variable
   \env{PE_HOSTFILE}.
   An example of a job submission that results in this is
   \code{qsub -pe mpi 8} (or \code{qsub -pe ompi 8}), which
   requests eight cores on a any number of machines.
}
}
\seealso{
To get the number of available workers on the current machine,
see \code{\link{availableCores}()}.
}
\keyword{internal}
