% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multisession.R
\name{multisession}
\alias{multisession}
\title{Create a multisession future whose value will be resolved asynchronously in a parallel \R session}
\usage{
multisession(
  ...,
  workers = availableCores(),
  lazy = FALSE,
  rscript_libs = .libPaths(),
  envir = parent.frame()
)
}
\arguments{
\item{...}{Additional arguments passed to \code{\link[=Future]{Future()}}.}

\item{workers}{A positive numeric scalar or a function specifying the
maximum number of parallel futures that can be active at the same time
before blocking.
If a function, it is called without arguments \emph{when the future
is created} and its value is used to configure the workers.
The function should return a numeric scalar.}

\item{lazy}{If FALSE (default), the future is resolved
eagerly (starting immediately), otherwise not.}

\item{rscript_libs}{A character vector of \R package library folders that
the workers should use.  The default is \code{.libPaths()} so that multisession
workers inherits the same library path as the main \R session.
To avoid this, use \code{plan(multisession, ..., rscript_libs = NULL)}.
\emph{Important: Note that the library path is set on the workers when they are
created, i.e. when \code{plan(multisession)} is called.  Any changes to
\code{.libPaths()} in the main R session after the workers have been created
will have no effect.}
This is passed down as-is to \code{\link[parallelly:makeClusterPSOCK]{parallelly::makeClusterPSOCK()}}.}

\item{envir}{The \link{environment} from where global objects should be
identified.}
}
\value{
A \link{MultisessionFuture}.
If \code{workers == 1}, then all processing using done in the
current/main \R session and we therefore fall back to using
a lazy future.
}
\description{
A multisession future is a future that uses multisession evaluation,
which means that its \emph{value is computed and resolved in
parallel in another \R session}.
}
\details{
The background \R sessions (the "workers") are created using
\code{\link[=makeClusterPSOCK]{makeClusterPSOCK()}}.

The \code{multisession()} function will block if all available
\R session are occupied
and will be unblocked as soon as one of the already running
multisession futures is resolved.  For the total number of
\R sessions available including the current/main \R process, see
\code{\link[parallelly:availableCores]{parallelly::availableCores()}}.

A multisession future is a special type of cluster future.

The preferred way to create an multisession future is not to call
this function directly, but to register it via
\code{\link{plan}(multisession)} such that it becomes the default
mechanism for all futures.  After this \code{\link[=future]{future()}}
and \code{\link{\%<-\%}} will create \emph{multisession futures}.
}
\examples{
\donttest{

## Use multisession futures
plan(multisession)

## A global variable
a <- 0

## Create future (explicitly)
f <- future({
  b <- 3
  c <- 2
  a * b * c
})

## A multisession future is evaluated in a separate R session.
## Changing the value of a global variable will not affect
## the result of the future.
a <- 7
print(a)

v <- value(f)
print(v)
stopifnot(v == 0)

## Explicitly close multisession workers by switching plan
plan(sequential)
}
}
\seealso{
For processing in multiple forked \R sessions, see
\link{multicore} futures.

Use \code{\link[parallelly:availableCores]{parallelly::availableCores()}} to see the total number of
cores that are available for the current \R session.
}
